/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.common.utils.text.StringUtil;
import com.jiejing.fitness.finance.repository.entity.BranchBank;
import com.jiejing.fitness.finance.repository.mapper.BranchBankMapper;
import com.jiejing.mbp.MapperRepoService;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 支行 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-04-01
 */
@Service
public class BranchBankRpService extends MapperRepoService<Long, BranchBank, BranchBankMapper> {

  public Page<BranchBank> page(String bankCode, String branchName, Integer current, Integer size) {
    QueryWrapper<BranchBank> wrapper = new QueryWrapper<>();
    if (StringUtil.isNotBlank(bankCode)) {
      wrapper.like(BranchBank.BANK_CODE, bankCode);
    }
    if (StringUtil.isNotBlank(branchName)) {
      wrapper.like(BranchBank.BRANCH_NAME, branchName);
    }
    return super.findByWrapperPage(wrapper, current, size);
  }

}
