package com.jiejing.fitness.finance.service.cashier.params;

import com.jiejing.fitness.enums.finance.BrandCashierTransStateEnum;
import com.jiejing.fitness.enums.finance.BrandCashierTransTypeEnum;
import com.jiejing.fitness.enums.finance.PayOrderTypeEnum;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:46
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌收银流水分页Params")
public class PageStudioCashierParams {

  @ApiModelProperty(value = "场馆业务订单号")
  private String orderNo;

  @ApiModelProperty(value = "场馆业务子订单号")
  private String subOrderNo;

  @ApiModelProperty(value = "交易流水号")
  private String transNo;

  @ApiModelProperty("三方交易单号")
  private String thirdTransNo;

  @ApiModelProperty(value = "场馆ID")
  private String studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "购买人姓名")
  private String buyerName;

  @ApiModelProperty(value = "购买人手机号")
  private String buyerPhone;

  @ApiModelProperty("交易状态")
  private BrandCashierTransStateEnum transState;

  @ApiModelProperty("业务订单类型（来源）")
  private PayOrderTypeEnum orderType;

  @ApiModelProperty("交易类型：PAY-收款；REFUND-退款；")
  private BrandCashierTransTypeEnum transType;

  @ApiModelProperty("交易方式")
  private SubChannelEnums subChannel;

  @ApiModelProperty(value = "交易创建开始时间")
  private Date createStartTime;

  @ApiModelProperty(value = "交易创建结束时间")
  private Date createEndTime;

  @ApiModelProperty(value = "交易成功开始时间")
  private Date successStartTime;

  @ApiModelProperty(value = "交易成功结束时间")
  private Date successEndTime;

  @ApiModelProperty(value = "页码：0开始", required = true)
  @NotNull(message = "页码不能为空")
  private Integer current;

  @ApiModelProperty(value = "分页大小", required = true)
  @NotNull(message = "分页大小不能为空")
  private Integer size;

}
