package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.paycenter.common.enums.merchant.CertTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 14:02
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "品牌商户：法人信息")
public class BrandLegalVO {

  @EnumMapping(enumClass = CertTypeEnums.class)
  @ApiModelProperty(value = "法人证件类型")
  private String legalCertType;

  @ApiModelProperty(value = "法人姓名")
  private String legalName;

  @ApiModelProperty(value = "法人证件号")
  private String legalCertNo;

  @EnumMapping(enumClass = ExpireTypeEnums.class)
  @ApiModelProperty(value = "法人证件有效期类型")
  private String legalCertExpireType;

  @ApiModelProperty(value = "法人证件有效期开始日期")
  private Date legalCertStartDate;

  @ApiModelProperty(value = "法人证件有效期截止日期")
  private Date legalCertEndDate;

  @ApiModelProperty(value = "法人手机号")
  private String legalPhone;

  @ApiModelProperty(value = "法人身份证地址")
  private AddressVO legalAddress;

  @ApiModelProperty(value = "法人邮箱")
  private String legalEmail;

}
