package com.jiejing.fitness.finance.app;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.jiejing.common.config.idgen.EnableLeaseIdWorker;
import com.jiejing.fitness.event.finance.CashierEvent;
import com.jiejing.fitness.finance.service.event.ListenerService;
import com.jiejing.paycenter.common.event.MerchantEvent;
import com.jiejing.paycenter.common.event.MerchantSubChannelEvent;
import com.jiejing.paycenter.common.event.PayEvent;
import com.jiejing.paycenter.common.event.RefundEvent;
import com.jiejing.workflow.event.DelayTaskEvent;
import com.xiaomai.event.annotation.EnableEventBinding;
import com.xiaomai.event.annotation.EventConfig;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author chengyubing
 * @since 2024/2/19 16:04
 */
@Slf4j
@EnableAsync
@EnableScheduling
@EnableLeaseIdWorker
@MapperScan(value = {"com.jiejing.fitness.finance.repository.mapper"})
@EnableEventBinding(
    configs = {
        @EventConfig(event = MerchantEvent.class, binder = "biz-kafka"),
        @EventConfig(event = PayEvent.class, binder = "biz-kafka"),
        @EventConfig(event = RefundEvent.class, binder = "biz-kafka"),
        @EventConfig(event = CashierEvent.class, binder = "biz-kafka"),
        @EventConfig(event = DelayTaskEvent.class, binder = "biz-kafka"),
        @EventConfig(event = MerchantSubChannelEvent.class, binder = "biz-kafka"),
    },
    listenerClass = {ListenerService.class})
@EnableFeignClients(basePackages = {
    "com.jiejing.filecenter.api",
    "com.jiejing.paycenter.api",
    "com.jiejing.studio.api",
    "com.jiejing.message.api",
    "com.jiejing.fitness.rpc.api",
    "com.jiejing.auth.api",
    "com.jiejing.configcenter.api",
    "com.jiejing.workflow.api",
})
@SpringBootApplication(scanBasePackages = "com.jiejing", exclude = {
    DruidDataSourceAutoConfigure.class
})
public class FitnessFinanceApplication {

  public static void main(String[] args) {
    SpringApplication.run(FitnessFinanceApplication.class, args);
    System.out.println("FitnessFinanceApplication start success!");
    log.info("FitnessFinanceApplication start success!");
  }

}
