package com.jiejing.fitness.finance.service.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @author chengyubing
 * @since 2024/1/23 15:17
 */
public class FileUtils {

  public static File downloadToMemory(String url) {
    try {
      InputStream in = getInputStream(url);
      File tempFile = File.createTempFile(UUID.randomUUID().toString(), getSuffix(url));
      tempFile.deleteOnExit();
      try (FileOutputStream out = new FileOutputStream(tempFile)) {
        IOUtils.copy(in, out);
      }
      return tempFile;
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  private static String getSuffix(String url) {
    String[] split = url.split("\\?");
    String fileName = StringUtils.substringAfterLast(split[0], "/");
    String[] names = fileName.split("\\.");
    return "." + names[names.length - 1];
  }

  public static InputStream getInputStream(String url) {
    int max = 5;
    try {
      HttpURLConnection connection = (HttpURLConnection) (new URL(url).openConnection());
      // 设置不自动跟随重定向
      connection.setInstanceFollowRedirects(false);

      int count = 0;
      int responseCode;
      do {
        if (count++ > max) {
          throw new RuntimeException("资源链接过多的重定向");
        }
        responseCode = connection.getResponseCode();

        if (responseCode == HttpURLConnection.HTTP_MOVED_TEMP
            || responseCode == HttpURLConnection.HTTP_MOVED_PERM) {
          // 获取重定向后的URL
          String redirectedUrl = connection.getHeaderField("Location");

          System.out.println("重定向到新地址：" + redirectedUrl);

          connection = (HttpURLConnection) new URL(redirectedUrl).openConnection();
          // 再次设置为不自动跟随重定向
          connection.setInstanceFollowRedirects(false);
          continue;
        }
        break;
      } while (true);
      return connection.getInputStream();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

}
