package com.jiejing.fitness.finance.api.cashier.request;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "绑定流水")
public class BindStudioCashierRequest {

  @ApiModelProperty(value = "收银流水ID", required = true)
  @NotEmpty(message = "收银流水ID不能为空")
  private List<Long> ids;

  @ApiModelProperty(value = "订单ID", required = true)
  @NotBlank(message = "订单ID不能为空")
  private String orderNo;

  @ApiModelProperty(value = "订单号", required = true)
  @NotBlank(message = "订单号不能为空")
  private String businessNo;

  @ApiModelProperty(value = "子订单号", required = true)
  @NotBlank(message = "子订单号不能为空")
  private String subOrderNo;

}
