package com.jiejing.fitness.finance.api.cashier.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "解绑流水")
public class UnbindStudioCashierRequest {

  @ApiModelProperty(value = "收银流水ID", required = true)
  @NotEmpty(message = "收银流水ID不能为空")
  private List<Long> ids;

}
