package com.jiejing.fitness.finance.api.merchant.request.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 13:57
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "地址")
public class AddressInfo {

  @ApiModelProperty(value = "省Code")
  private String province;

  @ApiModelProperty(value = "市Code")
  private String city;

  @ApiModelProperty(value = "区Code")
  private String district;

  @ApiModelProperty(value = "省名称")
  private String provinceName;

  @ApiModelProperty(value = "市名称")
  private String cityName;

  @ApiModelProperty(value = "区名称")
  private String districtName;

  @ApiModelProperty(value = "详细地址", notes = "XX省XX市XX区XX街道")
  private String address;

}
