package com.jiejing.fitness.finance.api.merchant.request.model;

import com.jiejing.paycenter.common.enums.merchant.CardTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CertTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/20 15:10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "银行卡信息")
public class BrandBankCardInfo {

  @ApiModelProperty(value = "银行卡类型", required = true)
  @NotNull(message = "银行卡类型不能为空")
  private CardTypeEnums cardType;

  @ApiModelProperty(value = "银行卡号", required = true)
  @NotBlank(message = "银行卡号不能为空")
  private String cardNo;

  @ApiModelProperty(value = "银行卡账户名（对私卡：持卡人姓名；对公卡：开户许可证的名称）", required = true)
  @NotBlank(message = "银行卡账户名不能为空")
  private String cardName;

  @ApiModelProperty(value = "持卡人手机号（对私卡必填）")
  private String phone;

  @ApiModelProperty(value = "证件号（对私卡：持卡人身份证；）", notes = "对私卡必填")
  private String certNo;

  @ApiModelProperty(value = "证件类型", notes = "对私卡必填")
  private CertTypeEnums certType;

  @ApiModelProperty(value = "基本存款账户编号或开户许可证核准号", notes = "对公卡必填")
  private String baseDepositNo;

  @ApiModelProperty(value = "证件有效期类型", notes = "对私卡必填")
  private ExpireTypeEnums certExpireType;

  @ApiModelProperty(value = "持卡人证件有效期开始日期", notes = "对私卡必填")
  private Date certStartDate;

  @ApiModelProperty(value = "持卡人证件有效期截止日期")
  private Date certEndDate;

  @ApiModelProperty(value = "银行编码")
  private String bankCode;

  @ApiModelProperty(value = "银行名称")
  private String bankName;

  @ApiModelProperty(value = "支行名称")
  private String branchName;

  @ApiModelProperty(value = "支行联行号")
  private String branchCode;

  @ApiModelProperty(value = "开卡地址：省市区详细地址")
  private AddressInfo cardAddress;

}
