package com.jiejing.fitness.finance.repository.query;

import com.jiejing.fitness.enums.finance.BrandCashierTransStateEnum;
import com.jiejing.fitness.enums.finance.BrandCashierTransTypeEnum;
import com.jiejing.fitness.enums.finance.PayOrderTypeEnum;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 品牌收银流水分页
 *
 * @author chengyubing
 * @since 2024/2/29 11:12
 */
@Data
public class PageBrandCashierRecordQuery {

  /**
   * 场馆订单ID
   */
  private String orderNo;

  /**
   * 场馆订单号
   */
  private String businessNo;

  /**
   * 场馆业务子订单号
   */
  private String subOrderNo;

  /**
   * 是否存在子订单号, true-存在；false-不存在
   */
  private Boolean existSubOrderNo;

  /**
   * 交易流水号
   */
  private String transNo;

  /**
   * 三方交易单号
   */
  private String thirdTransNo;

  /**
   * 场馆ID
   */
  private String studioId;

  /**
   * 场馆名称
   */
  private String studioName;

  /**
   * 购买人姓名
   */
  private String buyerName;

  /**
   * 购买人手机号
   */
  private String buyerPhone;

  /**
   * 交易状态
   *
   * @see BrandCashierTransStateEnum
   */
  private String transState;

  /**
   * 交易状态
   *
   * @see BrandCashierTransStateEnum
   */
  private List<String> transStateList;

  /**
   * 业务订单类型（来源）
   *
   * @see PayOrderTypeEnum
   */
  private String orderType;

  /**
   * 交易类型：PAY-收款；REFUND-退款；
   *
   * @see BrandCashierTransTypeEnum
   */
  private String transType;

  /**
   * 交易方式
   *
   * @see SubChannelEnums
   */
  private String subChannel;

  /**
   * 交易创建开始时间
   */
  private Date createStartTime;

  /**
   * 交易创建结束时间
   */
  private Date createEndTime;

  /**
   * 交易成功开始时间
   */
  private Date successStartTime;

  /**
   * 交易成功结束时间
   */
  private Date successEndTime;

  /**
   * 页码：0开始
   */
  private Integer current;

  /**
   * 分页大小
   */
  private Integer size;
}
