package com.jiejing.fitness.finance.service.merchant;

import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import java.util.List;

/**
 * 品牌商户服务
 *
 * @author chengyubing
 * @since 2024/2/20 14:01
 */
public interface BrandMerchantService {

  /**
   * 绑定
   *
   * @param brandId    品牌ID
   * @param merchantId 商户ID
   */
  void bind(Long brandId, Long merchantId);

  /**
   * 解绑
   *
   * @param brandId    品牌ID
   * @param merchantId 商户ID
   */
  void unbind(Long brandId, Long merchantId);

  /**
   * 查看品牌绑定的所有商户
   *
   * @param brandId 品牌ID
   * @return 商户
   */
  List<BrandMerchantVO> list(Long brandId);

}
