package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.permcenter.api.config.request.QueryUserIdByCodeRequest;
import com.jiejing.permcenter.api.perm.AuthorityPermApi;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/4/17 17:20
 */
@Slf4j
@Service
public class PermissionRpcService {

  @Resource
  private AuthorityPermApi authorityPermApi;

  /**
   * 查询改作用域下具有改权限的人
   *
   * @param domain         作用域
   * @param tenantKey      key
   * @param permissionCode 权限code
   * @param includeSubTree 是否包含下属子权限点
   */
  public Set<Long> getUserIdByCode(String domain, String tenantKey, String permissionCode,
      boolean includeSubTree) {
    QueryUserIdByCodeRequest request = QueryUserIdByCodeRequest.builder()
        .domain(domain).tenantKey(tenantKey)
        .permissionCode(permissionCode).includeSubTree(includeSubTree).build();
    JsonResult<Set<Long>> result = authorityPermApi.queryUserIdByCode(request);
    return Optional.ofNullable(result.getResult()).orElse(new HashSet<>(1));
  }

}
