package com.jiejing.fitness.finance.service.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.List;

/**
 * @author chengyubing
 * @since 2024/3/2 15:18
 */
public class JsonUtil {

  public static <T> T convertObject(Object source, Class<T> clazz) {
    return JSON.parseObject(JSON.toJSONString(source), clazz);
  }

  public static <T> List<T> convertList(Object source, Class<T> clazz) {
    if (null == source) {
      return Lists.newArrayList();
    }
    return JSON.parseArray(JSON.toJSONString(source), clazz);
  }

}
