/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.fitness.finance.repository.entity.StudioSettleRecord;
import com.jiejing.fitness.finance.repository.mapper.StudioSettleRecordMapper;
import com.jiejing.mbp.MapperRepoService;
import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 场馆结算记录 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-04-07
 */
@Service
public class StudioSettleRecordRpService extends
    MapperRepoService<Long, StudioSettleRecord, StudioSettleRecordMapper> {

  public StudioSettleRecord getByMerchantIdAndSettleDate(Long merchantId, Date settleDate) {
    QueryWrapper<StudioSettleRecord> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioSettleRecord.MERCHANT_ID, merchantId);
    wrapper.eq(StudioSettleRecord.SETTLE_DATE, settleDate);
    wrapper.eq(StudioSettleRecord.TRANS_STATE, TransStateEnums.SUCCESS.getCode());
    wrapper.orderByDesc(StudioSettleRecord.ID);
    List<StudioSettleRecord> list = this.baseMapper.selectList(wrapper);
    return Optional.ofNullable(list).orElse(new ArrayList<>()).stream().findFirst().orElse(null);
  }

}