package com.jiejing.fitness.finance.api.task;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.task.request.CheckSettleRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/4/7 13:49
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = FitFinanceTaskApiFallback.class)
public interface FitFinanceTaskApi {

  String TAG = "【任务】任务调度";

  @ApiOperation(value = "对账", tags = {TAG})
  @PostMapping(value = "/private/task/checkSettle")
  JsonResult<Void> checkSettle(CheckSettleRequest request);

  @ApiOperation(value = "同步结算状态", tags = {TAG})
  @PostMapping(value = "/private/task/syncSettle")
  JsonResult<Void> syncSettle(CheckSettleRequest request);

}
