package com.jiejing.fitness.finance.service.pay.enums;


import com.jiejing.common.utils.text.StringUtil;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/4/19 12:17
 */
@Getter
@AllArgsConstructor
public enum RefundFailMessageReplaceEnums {

  /**
   *
   */
  OTHER("", "退款失败，请联系小麦乐动工作人员处理。"),
  E1("业务执行失败[可用余额不足]", "当前乐动收银余额不足，无法退款，请在线收款后再次发起退款或者线下处理退款。"),
  NOT_CURRENT_MERCHANT("不是当前商户号收款，金额无法线上原路退回。系统会产生新的收支",
      "不是当前商户号收款，金额无法线上原路退回。系统会产生新的收支"),
  DATE_LIMIT("仅支持350天内交易进行退款，金额无法线上原路退回。系统会产生新的收支",
      "仅支持350天内交易进行退款，金额无法线上原路退回。系统会产生新的收支"),
  TIME_LIMIT("当前时间段不支持退款，金额无法线上原路退回。系统会产生新的收支",
      "当前时间段不支持退款，金额无法线上原路退回。系统会产生新的收支"),
  AMOUNT_LIMIT("乐动收银可退金额不足，请先通过扫码收款收款后再进行退款或者线下处理退款",
      "乐动收银可退金额不足，请先通过扫码收款收款后再进行退款或者线下处理退款"),
  ;

  private final String source;

  private final String target;

  public static String convertBySource(String source) {
    if (StringUtil.isBlank(source)) {
      return null;
    }
    return Arrays.stream(RefundFailMessageReplaceEnums.values())
        .filter(e -> OTHER != e)
        .filter(e -> e.getSource().contains(source) || source.contains(e.getSource())).findFirst()
        .orElse(OTHER).getTarget();
  }


}
