package com.jiejing.fitness.finance.service.merchant.impl;

import com.google.common.collect.Lists;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.fitness.enums.finance.PartyTypeEnum;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.fitness.finance.repository.entity.PartyToMerchant;
import com.jiejing.fitness.finance.repository.entity.StudioMerchantApply;
import com.jiejing.fitness.finance.repository.service.PartyToMerchantRpService;
import com.jiejing.fitness.finance.repository.service.StudioMerchantApplyRpService;
import com.jiejing.fitness.finance.service.config.PayChannelProperties;
import com.jiejing.fitness.finance.service.global.ConfigService;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.fitness.finance.service.merchant.convert.MerchantConvert;
import com.jiejing.fitness.finance.service.rpc.MerchantRpcService;
import com.jiejing.fitness.finance.service.rpc.StudioRpcService;
import com.jiejing.paycenter.common.model.vo.MerchantVO;
import com.jiejing.studio.api.studio.vo.StudioVO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 品牌商户服务
 *
 * @author chengyubing
 * @since 2024/2/20 14:01
 */
@Slf4j
@Service
public class BrandMerchantServiceImpl implements BrandMerchantService {

  @Resource
  private PayChannelProperties config;

  @Resource
  private StudioMerchantApplyRpService studioMerchantApplyRpService;

  @Resource
  private PartyToMerchantRpService partyToMerchantRpService;

  @Resource
  private MerchantRpcService merchantRpcService;

  @Resource
  private ConfigService configService;

  @Resource
  private StudioRpcService studioRpcService;

  @Override
  public void bind(Long brandId, Long merchantId) {
    PartyToMerchant exist = partyToMerchantRpService.getOneByPartyAndMerchantId(config.getCashier(), brandId,
        PartyTypeEnum.BRAND, merchantId);
    if (null != exist) {
      return;
    }

    StudioMerchantApply apply = studioMerchantApplyRpService.getLatestOneSuccessByMerchantId(merchantId);
    partyToMerchantRpService.insert(
        MerchantConvert.convertPartyToMerchant(apply.getChannelNo(), brandId, PartyTypeEnum.BRAND,
            apply.getMerchantId(), apply.getMerchantNo()));
  }

  @Override
  public void unbind(Long brandId, Long merchantId) {
    partyToMerchantRpService.deleteByPartyAndMerchantId(brandId, PartyTypeEnum.BRAND, merchantId);
  }

  @Override
  public List<BrandMerchantVO> list(Long brandId) {
    List<PartyToMerchant> relations = partyToMerchantRpService.listByParty(brandId, PartyTypeEnum.BRAND,
        config.getCashier());
    if (CollectionUtil.isEmpty(relations)) {
      return Lists.newArrayList();
    }
    List<Long> merchantIds = relations.stream().map(PartyToMerchant::getMerchantId)
        .collect(Collectors.toList());
    Map<Long, StudioMerchantApply> applyMap = studioMerchantApplyRpService.mapByMerchantIds(merchantIds);
    List<PartyToMerchant> studioRelations = partyToMerchantRpService.listByMerchantIdsAndPartyType(
        merchantIds, PartyTypeEnum.STUDIO);
    List<Long> studioIds = studioRelations.stream().map(PartyToMerchant::getPartyId)
        .collect(Collectors.toList());
    Map<Long, List<StudioVO>> studioMap = studioRpcService.mapStudioByBrandId(studioIds);
    List<MerchantVO> merchants = merchantRpcService.listByIds(merchantIds);
    return MerchantConvert.convertBrandMerchantList(brandId, merchants,
        configService.getDefaultBrandSubChannelInfo(), studioMap, applyMap);
  }

}
