package com.jiejing.fitness.finance.api.pay;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.pay.request.AppPayRequest;
import com.jiejing.fitness.finance.api.pay.request.NativePayRequest;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.SyncPayRequest;
import com.jiejing.paycenter.common.model.vo.PayVO;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/4/11 10:07
 */
@Component
public class FitPayApiFallback implements FallbackFactory<FitPayApi> {

  @Override
  public FitPayApi create(Throwable throwable) {
    return new FitPayApi() {

      @Override
      public JsonResult<PayVO> nativePay(NativePayRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PayVO> appPay(AppPayRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PayVO> get(SyncPayRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
