package com.jiejing.fitness.finance.api.cashier.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌收银流水查看详情Request")
public class GetBrandCashierByIdRequest {

  @ApiModelProperty(value = "收银流水ID", required = true)
  @NotNull(message = "收银流水ID不能为空")
  private Long id;

}
