package com.jiejing.fitness.finance.api.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/2/27 12:00
 */
@Getter
@AllArgsConstructor
public enum BrandCashierTransStateEnums {

  /**
   * 交易状态：0-支付初始态；1-支付中；2-支付失败；3-入账中（支付成功）；4-入账成功；5-退款中；6-退款成功；7-退款失败
   */
  PAY_INIT(0, "支付初始态"),
  PAYING(1, "支付中"),
  PAY_FAIL(2, "支付失败"),
  PAY_SUCCESS(3, "入账中（支付成功）"),
  PAY_IN(4, "入账成功"),
  REFUNDING(5, "退款中"),
  REFUND_SUCCESS(6, "退款成功"),
  REFUND_FAIL(7, "退款失败"),
  ;

  @EnumValue
  private final Integer code;

  private final String desc;


}
