package com.jiejing.fitness.finance.api.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.request.GetBrandCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListBrandCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageBrandCashierRequest;
import com.jiejing.fitness.finance.api.cashier.vo.BrandCashierRecordVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/2/29 10:42
 */
@Slf4j
@Component
public class BrandCashierApiFallback implements FallbackFactory<BrandCashierApi> {

  @Override
  public BrandCashierApi create(Throwable throwable) {
    return new BrandCashierApi() {
      @Override
      public JsonResult<PageVO<BrandCashierRecordVO>> page(PageBrandCashierRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandCashierRecordVO> getById(GetBrandCashierByIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<BrandCashierRecordVO>> listByOrderNo(ListBrandCashierByOrderNoRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
