package com.jiejing.fitness.finance.api.cashier.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆收银流水查看详情Request")
public class ListStudioCashierByTransNoRequest {

  @ApiModelProperty(value = "收银流水单号", required = true)
  @NotEmpty(message = "收银流水单号不能为空")
  private List<String> transNos;

}
