package com.jiejing.fitness.finance.api.bank.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/1 14:15
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "银行")
public class BankVO {

  @ApiModelProperty(value = "主键")
  private Integer id;

  @ApiModelProperty(value = "银行编码")
  private String bankCode;

  @ApiModelProperty(value = "银行名称")
  private String bankName;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;

}
