package com.jiejing.fitness.finance.api.cashier.request;

import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/7 18:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "分页查询场馆结算记录参数")
public class PageStudioSettleRequest {

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "商户号")
  private String merchantNo;

  @ApiModelProperty(value = "结算状态")
  private TransStateEnums transState;

  @ApiModelProperty(value = "开始时间")
  private Date startTime;

  @ApiModelProperty(value = "结束时间")
  private Date endTime;

  @ApiModelProperty(value = "页码：0开始", required = true)
  @NotNull(message = "页码不能为空")
  private Integer current;

  @ApiModelProperty(value = "分页大小", required = true)
  @NotNull(message = "分页大小不能为空")
  private Integer size;

}
