package com.jiejing.fitness.finance.api.merchant.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 品牌申请商户请求
 *
 * @author chengyubing
 * @since 2024/2/20 14:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "查询场馆商户请求信息")
public class GetStudioMerchantRequest {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

}
