package com.jiejing.fitness.finance.api.task;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.task.request.CheckSettleRequest;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/4/7 13:49
 */
@Component
public class FitFinanceTaskApiFallback implements FallbackFactory<FitFinanceTaskApi> {

  @Override
  public FitFinanceTaskApi create(Throwable throwable) {
    return new FitFinanceTaskApi() {
      @Override
      public JsonResult<Void> checkSettle(CheckSettleRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
