/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 支行
 * </p>
 *
 * @author chengyubing, created on 2024-04-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class BranchBank implements Serializable {

  private static final long serialVersionUID = 6464978615579112492L;

  /**
   * 备注: 主键 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.AUTO)
  private Integer id;

  /**
   * 备注: 支行号 是否允许为null: YES
   */
  private String bankUnionCode;

  /**
   * 备注: 支行名称 是否允许为null: YES
   */
  private String branchName;

  /**
   * 备注: 银行编码 是否允许为null: YES
   */
  private String bankCode;

  /**
   * 备注: 银行名称 是否允许为null: YES
   */
  private String bankName;

  /**
   * 备注: 省份编码 是否允许为null: YES
   */
  private String provinceCode;

  /**
   * 备注: 省份名称 是否允许为null: YES
   */
  private String provinceName;

  /**
   * 备注: 城市编码 是否允许为null: YES
   */
  private String cityCode;

  /**
   * 备注: 城市名称 是否允许为null: YES
   */
  private String cityName;

  /**
   * 备注: 创建时间 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String BANK_UNION_CODE = "bank_union_code";

  public static final String BRANCH_NAME = "branch_name";

  public static final String BANK_CODE = "bank_code";

  public static final String BANK_NAME = "bank_name";

  public static final String PROVINCE_CODE = "province_code";

  public static final String PROVINCE_NAME = "province_name";

  public static final String CITY_CODE = "city_code";

  public static final String CITY_NAME = "city_name";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
