package com.jiejing.fitness.finance.repository.query;

import com.jiejing.fitness.enums.finance.ApplyTypeEnum;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * @author chengyubing
 * @since 2024/2/22 18:03
 */
@Data
public class PageStudioMerchantApplyQuery {

  /**
   * 商户简称
   */
  private String shortName;

  /**
   * 操作类型
   */
  private ApplyTypeEnum applyType;

  /**
   * 操作类型列表
   */
  private List<ApplyTypeEnum> applyTypeList;

  /**
   * 场馆ID
   */
  private Long studioId;

  /**
   * 申请类型
   */
  private CompanyTypeEnums companyType;

  /**
   * 商户名称
   */
  private String merchantName;

  /**
   * 申请状态
   */
  private OpenStateEnums openState;

  /**
   * 商户号
   */
  private String merchantNo;

  /**
   * 支付宝商户号
   */
  private String aliMerchantNo;

  /**
   * 微信线上商户号
   */
  private String wxOnlineMerchantNo;

  /**
   * 微信线下商户号
   */
  private String wxOfflineMerchantNo;

  /**
   * 申请开始日期
   */
  private Date startTime;

  /**
   * 申请结束日期
   */
  private Date endTime;

  /**
   * 页码：0开始
   */
  private Integer current;

  /**
   * 分页大小
   */
  private Integer size;


}
