package com.jiejing.fitness.finance.service.bank.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/1 14:15
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "支行")
public class BranchBankDTO {

  @ApiModelProperty(value = "主键")
  private Integer id;

  @ApiModelProperty(value = "支行号")
  private String bankUnionCode;

  @ApiModelProperty(value = "支行名称")
  private String branchName;

  @ApiModelProperty(value = "银行编码")
  private String bankCode;

  @ApiModelProperty(value = "银行名称")
  private String bankName;

  @ApiModelProperty(value = "省份编码")
  private String provinceCode;

  @ApiModelProperty(value = "省份名称")
  private String provinceName;

  @ApiModelProperty(value = "城市编码")
  private String cityCode;

  @ApiModelProperty(value = "城市名称")
  private String cityName;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;

}
