package com.jiejing.fitness.finance.service.cashier.convert;

import com.google.common.collect.Lists;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.common.utils.crypt.AesUtil;
import com.jiejing.common.utils.text.SensitiveUtil;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import com.jiejing.fitness.finance.repository.entity.StudioCashierRecord;
import com.jiejing.fitness.finance.repository.entity.StudioSettleRecord;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;

/**
 * @author chengyubing
 * @since 2024/2/29 11:09
 */
public class CashierConvert {

  public static StudioCashierRecordVO convertVO(StudioCashierRecord record) {
    return StudioCashierRecordVO.builder()
        .id(record.getId())
        .transNo(record.getTransNo())
        .orderNo(record.getOrderNo())
        .orderType(record.getOrderType())
        .transType(record.getTransType())
        .brandId(record.getBrandId())
        .studioId(record.getStudioId())
        .studioName(record.getStudioName())
        .merchantId(record.getMerchantId())
        .merchantNo(record.getMerchantNo())
        .channelNo(record.getChannelNo())
        .subChannel(record.getSubChannel())
        .transAmount(record.getTransAmount())
        .feeRate(record.getFeeRate())
        .fee(record.getFee())
        .actualAmount(record.getActualAmount())
        .transState(record.getTransState())
        .buyerName(record.getBuyerName())
        .buyerPhone(record.getBuyerPhone())
        .goods(record.getGoods())
        .remark(record.getRemark())
        .existRelatedTrans(record.getExistRelatedTrans())
        .relatedTransNo(record.getRelatedTransNo())
        .thirdTransNo(record.getThirdTransNo())
        .failMessage(record.getFailMessage())
        .tradingTime(record.getTradingTime())
        .successTime(record.getSuccessTime())
        .inTime(record.getInTime())
        .createTime(record.getCreateTime())
        .updateTime(record.getUpdateTime())
        .build();
  }

  public static List<StudioCashierRecordVO> convertList(List<StudioCashierRecord> list) {
    if (CollectionUtil.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list.stream().map(CashierConvert::convertVO).collect(Collectors.toList());
  }

  public static PageVO<StudioCashierRecordVO> convertPageVO(Page<StudioCashierRecord> page) {
    return PageVO.convert(page, convertList(page.getContent()));
  }

  public static PageVO<StudioSettleVO> convertSettlePageVO(Page<StudioSettleRecord> page) {
    return PageVO.convert(page, convertSettleList(page.getContent()));
  }

  private static List<StudioSettleVO> convertSettleList(List<StudioSettleRecord> list) {
    if (CollectionUtil.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list.stream().map(CashierConvert::convertSettleVO).collect(Collectors.toList());
  }

  private static StudioSettleVO convertSettleVO(StudioSettleRecord record) {
    StudioSettleVO vo = BeanUtil.map(record, StudioSettleVO.class);
    vo.setCardNo(SensitiveUtil.bankCard(AesUtil.decrypt(record.getSalt(), record.getCardNo())));
    return vo;
  }
}
