package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.message.api.SendMessageApi;
import com.jiejing.message.api.request.VerifyCodeCheckRequest;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/4/2 10:00
 */
@Slf4j
@Service
public class MessageRpcService {

  @Resource
  private SendMessageApi sendMessageApi;

  public void validSmsCode(String phone, String code, String bizType) {
    VerifyCodeCheckRequest request = VerifyCodeCheckRequest.builder().phone(phone).bizType(bizType).code(code)
        .build();
    sendMessageApi.verifyCodeCheck(request).assertSuccess();
  }

}
