package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.paycenter.api.pay.PayApi;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.RefundPayRequest;
import com.jiejing.paycenter.api.pay.request.SyncSettleRequest;
import com.jiejing.paycenter.common.model.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import com.jiejing.paycenter.common.enums.pay.PayStateEnums;
import com.jiejing.paycenter.common.model.vo.SettleVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/27 11:12
 */
@Service
public class PayRpcService {

  @Resource
  private PayApi payApi;

  public PayVO pay(PayRequest request) {
    try {
      JsonResult<PayVO> result = payApi.pay(request);
      result.assertSuccess();
      return result.getResult();
    } catch (Exception e) {
      return PayVO.builder().payState(PayStateEnums.FAILED.name()).failMsg(e.getMessage()).build();
    }
  }

  public RefundVO refund(RefundPayRequest request) {
    try {
      JsonResult<RefundVO> result = payApi.refund(request);
      result.assertSuccess();
      return result.getResult();
    } catch (Exception e) {
      return RefundVO.builder().refundState(TransStateEnums.FAIL.name()).failMessage(e.getMessage()).build();
    }
  }

  public SettleVO syncSettle(Long merchantId, Date settleDate) {
    JsonResult<SettleVO> result = payApi.syncSettle(SyncSettleRequest.builder()
        .merchantId(merchantId)
        .settleDate(settleDate)
        .build());
    result.assertSuccess();
    return Optional.ofNullable(result.getResult())
        .orElse(SettleVO.builder().transAmount(BigDecimal.ZERO).build());
  }
}
