package com.jiejing.fitness.finance.api.axf.request;

import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @author chengyubing
 * @since 2024/9/7 11:11
 */
@Data
@ApiModel(description = "先学后付请求")
public class StudioAxfApplyRequest {

  @ApiModelProperty(value = "支付宝商户号不能为空", required = true)
  @NotBlank(message = "支付宝商户号不能为空")
  private String merchantNo;

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(value = "品牌ID", required = true)
  @NotNull(message = "品牌ID不能为空")
  private Long brandId;

  @ApiModelProperty(value = "商户名称")
  private String merchantName;

  @ApiModelProperty(value = "商户简称")
  private String shortName;

  @ApiModelProperty(value = "企业类型")
  private CompanyTypeEnums companyType;

  @ApiModelProperty(value = "营业执照编号")
  private String licenseCode;

  @ApiModelProperty(value = "营业执照名称")
  private String licenseName;

  @ApiModelProperty(value = "营业执照有效期类型")
  private ExpireTypeEnums licenseExpireType;

  @ApiModelProperty(value = "营业执照有效期开始时间")
  private Date licenseStartTime;

  @ApiModelProperty(value = "营业执照有效期结束时间")
  private Date licenseEndTime;

  @ApiModelProperty(value = "法人姓名")
  private String legalName;

  @ApiModelProperty(value = "法人证件号")
  private String legalCertNo;

  @ApiModelProperty(value = "联系人手机号")
  private String phone;

  @ApiModelProperty(value = "结算账户号")
  private String cardNo;

  @ApiModelProperty(value = "经营地址-省份code")
  private String businessProvinceCode;

  @ApiModelProperty(value = "经营地址-省份名称")
  private String businessProvinceName;

  @ApiModelProperty(value = "经营地址城市code")
  private String businessCityCode;

  @ApiModelProperty(value = "经营地址城市名称")
  private String businessCityName;

  @ApiModelProperty(value = "经营地址县区code")
  private String businessDistrictCode;

  @ApiModelProperty(value = "经营地址县区名称")
  private String businessDistrictName;

  @ApiModelProperty(value = "经营详细地址")
  private String businessAddress;

  @ApiModelProperty(value = "营业执照资源ID")
  private Long licenseResourceId;

  @ApiModelProperty(value = "门头照资源ID")
  private Long storeHeadResourceId;

  @ApiModelProperty(value = "员工ID", required = true)
  @NotNull(message = "员工ID不能为空")
  private Long operatorId;

}
