package com.jiejing.fitness.finance.api.merchant.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 14:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户：进件资料")
public class BrandResourceVO {

  @ApiModelProperty(value = "营业执照图片")
  private Long licensePicId;

  @ApiModelProperty(value = "线下经营门头照")
  private Long storeHeaderPicId;

  @ApiModelProperty(value = "线下经营内景照")
  private Long storeInnerPicId;

  @ApiModelProperty(value = "线下经营收银台")
  private Long storeCashierDescPicId;

  @ApiModelProperty(value = "法人证件人像面（正面）")
  private Long legalCertFrontPicId;

  @ApiModelProperty(value = "法人证件国徽面（反面）")
  private Long legalCertBackPicId;

  @ApiModelProperty(value = "银行卡正面")
  private Long bankCardFrontPicId;

  @ApiModelProperty(value = "银行卡反面")
  private Long bankCardBackPicId;

  @ApiModelProperty(value = "结算卡持卡人证件人像面（正面）")
  private Long bankCardCertFrontPicId;

  @ApiModelProperty(value = "结算卡持卡人证件国徽面(反面)")
  private Long bankCardCertBackPicId;


  @ApiModelProperty(value = "营业执照图片URL")
  private String licensePicUrl;

  @ApiModelProperty(value = "线下经营门头照URL")
  private String storeHeaderPicUrl;

  @ApiModelProperty(value = "线下经营内景照URL")
  private String storeInnerPicUrl;

  @ApiModelProperty(value = "线下经营收银台URL")
  private String storeCashierDescPicUrl;

  @ApiModelProperty(value = "法人证件人像面（正面）URL")
  private String legalCertFrontPicUrl;

  @ApiModelProperty(value = "法人证件国徽面（反面）URL")
  private String legalCertBackPicUrl;

  @ApiModelProperty(value = "银行卡正面URL")
  private String bankCardFrontPicUrl;

  @ApiModelProperty(value = "银行卡反面URL")
  private String bankCardBackPicUrl;

  @ApiModelProperty(value = "结算卡持卡人证件人像面（正面）URL")
  private String bankCardCertFrontPicUrl;

  @ApiModelProperty(value = "结算卡持卡人证件国徽面(反面)URL")
  private String bankCardCertBackPicUrl;

}
