package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/5/10 13:40
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆商户退款校验VO")
public class StudioMerchantCheckRefundVO {

  @EnumMapping(enumClass = CheckRefundCodeEnum.class)
  @ApiModelProperty(value = "退款前置校验code")
  private String code;

  @ApiModelProperty(name = "失败原因")
  private String failMessage;

  @Getter
  @AllArgsConstructor
  public enum CheckRefundCodeEnum {

    /**
     * 退款校验CODE，退款失败CODE
     */
    SUCCESS("校验成功"),
    NOT_CURRENT_MERCHANT("不是当前商户号收款，金额无法线上原路退回。"),
    DATE_LIMIT("仅支持350天内交易进行退款，金额无法线上原路退回。"),
    TIME_LIMIT("当前时间段内不支持退款，请于04:00~23:30时间段内操作乐动收银退款。"),
    AMOUNT_LIMIT("订单关联流水可退金额不足，请修改退款金额后重试"),
    OTHER_ERROR("其他错误"),
    ;

    private final String code = name();
    private final String message;

    public static CheckRefundCodeEnum getByCode(String code) {
      return Arrays.stream(CheckRefundCodeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst()
          .orElse(OTHER_ERROR);
    }

    public static boolean isSuccess(String code) {
      return CheckRefundCodeEnum.SUCCESS == getByCode(code);
    }

    public static boolean isFail(String code) {
      return !isSuccess(code);
    }
  }

}
