package com.jiejing.fitness.finance.app.controller.axf;

import com.google.common.collect.Lists;
import com.jiejing.common.enums.ConfirmEnum;
import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.request.IdsRequest;
import com.jiejing.fitness.finance.api.axf.StudioAxfOrderApi;
import com.jiejing.fitness.finance.api.axf.request.*;
import com.jiejing.fitness.finance.api.axf.vo.*;
import com.jiejing.fitness.finance.service.axf.AxfService;
import com.jiejing.paycenter.common.model.vo.*;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/9/7 11:30
 */
@RestController
public class StudioAxfOrderController implements StudioAxfOrderApi {

  @Resource
  private AxfService axfService;

  @ApiOperation(value = "取消订购单")
  @PostMapping(value = "/private/axfOrder/cancel")
  @Override
  public JsonResult<CancelCommodityOrderVO> cancel(@RequestBody @Valid CancelStudioAxfOrderRequest request) {
    return JsonResult.success(axfService.cancelOrder(request.getId(), request.getBizAccountId()));
  }

  @ApiOperation(value = "分页查询订购单")
  @PostMapping(value = "/private/axfOrder/page")
  @Override
  public JsonResult<PageVO<StudioAxfOrderVO>> page(@RequestBody @Valid PageStudioAxfOrderRequest request) {
    return JsonResult.success(axfService.pageOrder(request));
  }

  @ApiOperation(value = "统计订购单")
  @PostMapping(value = "/private/axfOrder/agg")
  @Override
  public JsonResult<AggStudioAxfOrderVO> agg(@RequestBody @Valid PageStudioAxfOrderRequest request) {
    return JsonResult.success(axfService.aggOrder(request));
  }

  @ApiOperation(value = "查询订购单详情")
  @PostMapping(value = "/private/axfOrder/getById")
  @Override
  public JsonResult<StudioAxfOrderVO> getById(@RequestBody @Valid GetStudioAxfOrderRequest request) {
    return JsonResult.success(axfService.getOrder(request.getId()));
  }

  @ApiOperation(value = "根据订单查询安心付订购单")
  @PostMapping(value = "/private/axfOrder/getByVoucherId")
  @Override
  public JsonResult<StudioAxfOrderVO> getByVoucherId(
      @RequestBody @Valid GetStudioAxfOrderByVoucherIdRequest request) {
    return JsonResult.success(axfService.getByVoucherId(request.getVoucherId()));
  }

  @ApiOperation(value = "批量根据订单查询安心付订购单")
  @PostMapping(value = "/private/axfOrder/listByVoucherIds")
  @Override
  public JsonResult<List<StudioAxfOrderVO>> listByVoucherIds(
      @RequestBody @Valid ListStudioAxfOrderByVoucherIdsRequest request) {
    List<StudioAxfOrderVO> axfOrderVOS = Lists.newArrayList();
    request.getVoucherIds().forEach(voucherId->{
      StudioAxfOrderVO axfOrderVO = axfService.getByVoucherId(voucherId);
      if (null != axfOrderVO){
        axfOrderVOS.add(axfOrderVO);
      }
    });
    return JsonResult.success(axfOrderVOS);
  }

  @ApiOperation(value = "查询订购单扣款明细")
  @PostMapping(value = "/private/axfOrder/listDeduction")
  @Override
  public JsonResult<List<StudioAxfOrderDeductionVO>> listDeduction(
      @RequestBody @Valid ListStudioAxfOrderDeductionRequest request) {
    return JsonResult.success(axfService.listDeduction(request.getOrderId()));
  }

  @ApiOperation(value = "校验是否存在失败的扣款")
  @PostMapping(value = "/private/axfOrder/existFailDeduction")
  @Override
  public JsonResult<ConfirmEnum> existFailDeduction(
      @RequestBody @Valid ListStudioAxfOrderDeductionRequest request) {
    return JsonResult.success(axfService.existFailDeduction(request.getOrderId()));
  }

  @ApiOperation(value = "查询订购单追缴明细")
  @PostMapping(value = "/private/axfOrder/listRecovery")
  @Override
  public JsonResult<List<StudioAxfOrderRecoveryVO>> listRecovery(
      @RequestBody @Valid ListStudioAxfOrderRecoveryRequest request) {
    return JsonResult.success(axfService.listRecovery(request.getDeductionId()));
  }

}
