package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.workflow.api.DelayQueueApi;
import com.jiejing.workflow.api.request.BatchSaveDelayTaskRequest;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/8/15 10:02
 */
@Slf4j
@Service
public class DelayTaskRpcService {

  @Resource
  private DelayQueueApi delayQueueApi;

  public void batchSave(BatchSaveDelayTaskRequest request) {
    JsonResult<Void> result = delayQueueApi.batchSave(request);
    if (!result.getSuccess()) {
      log.error("batch save delay task fail {}", result);
    }
  }

}
