package com.jiejing.fitness.finance.service.pay.enums;

import static com.jiejing.fitness.finance.service.enums.FinanceErrorEnums.*;

import com.jiejing.fitness.finance.service.enums.FinanceErrorEnums;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/4/19 12:17
 */
@Getter
@AllArgsConstructor
public enum PayFailMessageReplaceEnums {

  /**
   *
   */
  OTHER("OTHER__", PAY_FAIL_1),
  E1("当前商户需补齐相关资料后，才可进行相应的支付交易，请商户联系微信服务商", PAY_FAIL_4),
  E2("当前商户需补齐相关资料后，才可进行相应的支付交易，请商户联系服务商", PAY_FAIL_5),
  ;

  private final String source;

  private final FinanceErrorEnums target;

  public static FinanceErrorEnums convertBySource(String source) {
    if (null == source) {
      return OTHER.getTarget();
    }
    return Arrays.stream(PayFailMessageReplaceEnums.values())
        .filter(e -> e.getSource().contains(source) || source.contains(e.getSource())).findFirst()
        .orElse(OTHER).getTarget();
  }


}
