package com.jiejing.fitness.finance.service.pay.convert;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.enums.finance.BrandCashierTransStateEnum;
import com.jiejing.fitness.finance.repository.entity.StudioCashierRecord;
import com.jiejing.fitness.finance.service.pay.params.StudioMerchantRefundParams;
import com.jiejing.fitness.finance.service.utils.FeeUtil;
import com.jiejing.fitness.finance.service.utils.MoneyUtil;
import com.jiejing.paycenter.api.pay.request.RefundPayRequest;
import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import com.jiejing.paycenter.common.event.RefundEvent;
import com.jiejing.paycenter.common.model.vo.RefundVO;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author chengyubing
 * @since 2024/5/7 16:48
 */
public class RefundConvert {

  public static StudioCashierRecord convertRefundInit(StudioMerchantRefundParams params,
      StudioCashierRecord pay, BigDecimal historyRefundActualAmount) {
    StudioCashierRecord record = BeanUtil.map(pay, StudioCashierRecord.class);
    record.setId(IdWorker.getId());
    record.setTransNo(record.getId().toString());
    record.setOrderNo(params.getOrderNo());
    record.setRelatedTransNo(params.getPayTransNo());
    record.setTransAmount(params.getTransAmount());
    record.setFeeRate(pay.getFeeRate());
    record.setFee(
        FeeUtil.calculateRefundFee(params.getTransAmount(), pay.getTransAmount(), pay.getActualAmount(),
            pay.getFee(), historyRefundActualAmount));
    record.setActualAmount(MoneyUtil.subtract(record.getTransAmount(), record.getFee()));
    record.setRemark(params.getRefundReason());
    record.setStudioId(params.getStudioId());
    record.setTransState(BrandCashierTransStateEnum.REFUND_INIT.getCode());
    record.setTradingTime(new Date());
    record.setCreateTime(new Date());
    record.setUpdateTime(new Date());
    return record;
  }

  public static RefundPayRequest convert(StudioMerchantRefundParams params, StudioCashierRecord record) {
    RefundPayRequest request = BeanUtil.map(params, RefundPayRequest.class);
    request.setTransNo(record.getTransNo());
    return request;
  }

  public static StudioCashierRecord convertRefund(StudioCashierRecord record, RefundVO vo) {
    return StudioCashierRecord.builder()
        .id(record.getId())
        .transState(PayConvert.convertTransState(TransStateEnums.getByCode(vo.getRefundState())).getCode())
        .failMessage(vo.getFailMessage())
        .successTime(vo.getSuccessTime())
        .updateTime(new Date())
        .build();
  }

  public static StudioCashierRecord convertRefund(StudioCashierRecord record, RefundEvent event) {
    return StudioCashierRecord.builder()
        .id(record.getId())
        .transState(PayConvert.convertTransState(TransStateEnums.getByCode(event.getRefundState())).getCode())
        .failMessage(event.getFailMessage())
        .successTime(event.getSuccessTime())
        .updateTime(new Date())
        .build();
  }

  public static BrandCashierTransStateEnum convertTransState(String refundState) {
    TransStateEnums state = TransStateEnums.getByCode(refundState);
    switch (state) {
      case SUCCESS:
        return BrandCashierTransStateEnum.REFUND_SUCCESS;
      case FAIL:
        return BrandCashierTransStateEnum.REFUND_FAIL;
      case INIT:
      case PROCESS:
        return BrandCashierTransStateEnum.REFUNDING;
      default:
        return null;
    }
  }
}
