package com.jiejing.fitness.finance.api.merchant.request;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandBankCardInfo;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandLegalInfo;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandLicenseInfo;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandResourceInfo;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ResourceTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 品牌申请商户请求
 *
 * @author chengyubing
 * @since 2024/2/20 14:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "申请场馆商户请求信息")
public class ApplyStudioMerchantRequest {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(value = "企业类型", required = true)
  @NotNull(message = "企业类型不能为空")
  private CompanyTypeEnums companyType;

  @ApiModelProperty(value = "商户名称", required = true)
  @NotBlank(message = "商户名称不能为空")
  @Size(max = 32, message = "最多32个字")
  private String merchantName;

  @ApiModelProperty(value = "营业执照", required = true)
  @NotNull(message = "营业执照不能为空")
  @Valid
  private BrandLicenseInfo license;

  @ApiModelProperty(value = "法人信息", required = true)
  @NotNull(message = "法人信息不能为空")
  @Valid
  private BrandLegalInfo legal;

  @ApiModelProperty(value = "结算卡信息", required = true)
  @NotNull(message = "结算卡信息不能为空")
  @Valid
  private BrandBankCardInfo bankCard;

  @EnumMapping(enumClass = ResourceTypeEnums.class)
  @ApiModelProperty(value = "进件所需资料", required = true, notes = "key从ResourceTypeEnums获取")
  @NotEmpty(message = "进件所需资料不能为空")
  @Valid
  private Map<String, BrandResourceInfo> resourceMap;

  @ApiModelProperty(value = "验证码", required = true)
  @NotBlank(message = "验证码不能为空")
  private String smsCode;

}
