package com.jiejing.fitness.finance.api.merchant.request.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 13:57
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "地址")
public class AddressInfo {

  @ApiModelProperty(value = "省", required = true)
  @NotBlank(message = "省份不能为空")
  private String province;

  @ApiModelProperty(value = "市", required = true)
  @NotBlank(message = "市不能为空")
  private String city;

  @ApiModelProperty(value = "区", required = true)
  @NotBlank(message = "区不能为空")
  private String district;

  @ApiModelProperty(value = "详细地址", notes = "XX省XX市XX区XX街道")
  private String address;

}
