package com.jiejing.fitness.finance.app.controller.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.merchant.StudioMerchantApi;
import com.jiejing.fitness.finance.api.merchant.request.ApplyStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.AuthStudioSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindStudioMerchantXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetAuthStudioSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageStudioMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.StudioMerchantPayRequest;
import com.jiejing.fitness.finance.api.merchant.request.UnbindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import com.jiejing.fitness.finance.service.merchant.StudioMerchantService;
import com.jiejing.fitness.finance.service.merchant.params.ApplyStudioMerchantParams;
import com.jiejing.fitness.finance.service.merchant.params.PageStudioMerchantApplyParams;
import com.jiejing.fitness.finance.service.pay.PayService;
import com.jiejing.fitness.finance.service.pay.params.StudioMerchantPayParams;
import com.jiejing.paycenter.common.model.vo.PayVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/3/5 09:56
 */
@RestController
public class StudioMerchantController implements StudioMerchantApi {

  @Resource
  private StudioMerchantService studioMerchantService;

  @Resource
  private PayService payService;

  @ApiOperation(value = "场馆入驻商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/getMerchant")
  @Override
  public JsonResult<StudioMerchantVO> getMerchant(@RequestBody @Valid GetStudioMerchantRequest request) {
    return JsonResult.success(studioMerchantService.getMerchant(request.getStudioId()));
  }

  @ApiOperation(value = "场馆入驻商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/apply")
  @Override
  public JsonResult<Long> apply(@RequestBody @Valid ApplyStudioMerchantRequest request) {
    ApplyStudioMerchantParams params = BeanUtil.map(request, ApplyStudioMerchantParams.class);
    return JsonResult.success(studioMerchantService.apply(params));
  }

  @ApiOperation(value = "场馆绑定商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/bind")
  @Override
  public JsonResult<Void> bind(@RequestBody @Valid BindStudioMerchantRequest request) {
    studioMerchantService.bind(request.getStudioId(), request.getMerchantId(), true);
    return JsonResult.success();
  }

  @ApiOperation(value = "场馆解绑商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/unbind")
  @Override
  public JsonResult<Void> unbind(@RequestBody @Valid UnbindStudioMerchantRequest request) {
    studioMerchantService.unbind(request.getStudioId(), request.getMerchantId());
    return JsonResult.success();
  }

  @ApiOperation(value = "查询场馆进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/getApply")
  @Override
  public JsonResult<StudioMerchantApplyVO> getApply(
      @RequestBody @Valid GetStudioMerchantApplyRequest request) {
    return JsonResult.success(studioMerchantService.getApply(request.getId()));
  }

  @ApiOperation(value = "分页查询场馆进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/pageApply")
  @Override
  public JsonResult<PageVO<StudioMerchantApplyVO>> pageApply(
      @RequestBody @Valid PageStudioMerchantApplyRequest request) {
    PageStudioMerchantApplyParams params = BeanUtil.map(request, PageStudioMerchantApplyParams.class);
    return JsonResult.success(studioMerchantService.pageApply(params));
  }

  @ApiOperation(value = "绑定微信小程序appId", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/bindXcxAppId")
  @Override
  public JsonResult<StudioMerchantBindXcxAppIdVO> bindXcxAppId(
      @RequestBody @Valid BindStudioMerchantXcxAppIdRequest request) {
    return JsonResult.success(studioMerchantService.bindXcxAppId(request.getStudioId(), request.getAppId()));
  }

  @ApiOperation(value = "授权子渠道", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/authSubChannel")
  @Override
  public JsonResult<StudioMerchantAuthSubChannelVO> authSubChannel(
      @RequestBody @Valid AuthStudioSubChannelRequest request) {
    return JsonResult.success(
        studioMerchantService.authSubChannel(request.getStudioId(), request.getSubChannel(),
            request.getAuthType()));
  }

  @ApiOperation(value = "查询授权子渠道结果", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/listAuthSubChannel")
  @Override
  public JsonResult<List<StudioMerchantAuthSubChannelVO>> listAuthSubChannel(
      @RequestBody @Valid GetAuthStudioSubChannelRequest request) {
    return JsonResult.success(studioMerchantService.listAuthSubChannel(request.getStudioId()));
  }

  @ApiOperation(value = "支付", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/pay")
  @Override
  public JsonResult<PayVO> pay(@RequestBody @Valid StudioMerchantPayRequest request) {
    StudioMerchantPayParams params = BeanUtil.map(request, StudioMerchantPayParams.class);
    return JsonResult.success(payService.merchantPay(params));
  }
}
