package com.jiejing.fitness.finance.service.cashier.impl;

import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import com.jiejing.fitness.finance.repository.entity.StudioCashierRecord;
import com.jiejing.fitness.finance.repository.entity.StudioSettleRecord;
import com.jiejing.fitness.finance.repository.query.PageBrandCashierRecordQuery;
import com.jiejing.fitness.finance.repository.query.PageStudioSettleQuery;
import com.jiejing.fitness.finance.repository.service.StudioCashierRecordRpService;
import com.jiejing.fitness.finance.repository.service.StudioSettleRecordRpService;
import com.jiejing.fitness.finance.service.cashier.StudioCashierService;
import com.jiejing.fitness.finance.service.cashier.convert.CashierConvert;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioCashierParams;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioSettleParams;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/29 11:08
 */
@Slf4j
@Service
public class StudioCashierServiceImpl implements StudioCashierService {

  @Resource
  private StudioCashierRecordRpService studioCashierRecordRpService;

  @Resource
  private StudioSettleRecordRpService studioSettleRecordRpService;

  @Override
  public StudioCashierRecordVO getById(Long id) {
    StudioCashierRecord record = studioCashierRecordRpService.getById(id).orElse(null);
    if (null == record) {
      return null;
    }
    return CashierConvert.convertVO(record);
  }

  @Override
  public List<StudioCashierRecordVO> listByOrderNo(String orderNo) {
    List<StudioCashierRecord> list = studioCashierRecordRpService.listByOrderNo(orderNo);
    return CashierConvert.convertList(list);
  }

  @Override
  public List<StudioCashierRecordVO> listBySubOrderNo(String subOrderNo) {
    List<StudioCashierRecord> list = studioCashierRecordRpService.listBySubOrderNo(subOrderNo);
    return CashierConvert.convertList(list);
  }

  @Override
  public PageVO<StudioCashierRecordVO> page(PageStudioCashierParams params) {
    PageBrandCashierRecordQuery query = BeanUtil.map(params, PageBrandCashierRecordQuery.class);
    Page<StudioCashierRecord> page = studioCashierRecordRpService.page(query);
    return CashierConvert.convertPageVO(page);
  }

  @Override
  public PageVO<StudioSettleVO> page(PageStudioSettleParams params) {
    PageStudioSettleQuery query = BeanUtil.map(params, PageStudioSettleQuery.class);
    Page<StudioSettleRecord> page = studioSettleRecordRpService.page(query);
    return CashierConvert.convertSettlePageVO(page);
  }
}
