package com.jiejing.fitness.finance.service.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商户业务类型
 *
 * @author raccoon
 * @since 2020-11-06 16:44
 */
@Getter
@AllArgsConstructor
public enum MerchantTypeEnums {

  /**
   * 未知
   */
  UNKNOWN("", ""),

  /**
   * 品牌
   */
  BRAND("BRAND", "品牌"),

  ;

  @EnumValue
  private final String code;

  private final String desc;

  public static MerchantTypeEnums getByCode(String code) {
    return Arrays.stream(MerchantTypeEnums.values()).filter(e -> e.getCode().equals(code)).findFirst()
        .orElse(UNKNOWN);
  }

}
