package com.jiejing.fitness.finance.api.merchant.request.model;

import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 13:57
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "品牌商户：营业执照信息")
public class BrandLicenseInfo {

  @ApiModelProperty(value = "营业执照编号", required = true)
  @NotBlank(message = "营业执照编号不能为空")
  private String licenseCode;

  @ApiModelProperty(value = "营业执照有效期类型", required = true)
  @NotNull(message = "营业执照有效期类型不能为空")
  private ExpireTypeEnums licenseExpireType;

  @ApiModelProperty(value = "营业执照有效期开始日期", required = true)
  @NotNull(message = "营业执照有效期开始日期不能为空")
  private Date licenseStartDate;

  @ApiModelProperty(value = "营业执照有效期截止日期")
  private Date licenseEndDate;

  @ApiModelProperty(value = "经营范围", required = true)
  @NotBlank(message = "经营范围不能为空")
  private String businessScope;

  @ApiModelProperty(value = "成立时间", required = true)
  @NotNull(message = "成立时间不能为空")
  private Date foundDate;

  @ApiModelProperty(value = "注册资本", notes = "国营企业、私营企业、外资企业、事业单位、其他、集体经济必填；政府机构、个体工商户可为空")
  private String registeredCapital;

  @ApiModelProperty(value = "注册地址", required = true)
  @NotNull(message = "注册地址不能为空")
  private AddressInfo licenseAddress;

}
