package com.jiejing.fitness.finance.service.global.impl;

import com.alibaba.fastjson.JSON;
import com.jiejing.common.exception.BizException;
import com.jiejing.fitness.finance.repository.entity.GlobalConfig;
import com.jiejing.fitness.finance.repository.service.GlobalConfigRpService;
import com.jiejing.fitness.finance.service.enums.FinanceErrorEnums;
import com.jiejing.fitness.finance.service.enums.GlobalConfigEnums;
import com.jiejing.fitness.finance.service.global.ConfigService;
import com.jiejing.fitness.finance.service.global.dto.RefundConfigDTO;
import com.jiejing.fitness.finance.service.global.dto.SubChannelInfoDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/3/6 18:09
 */
@Service
public class ConfigServiceImpl implements ConfigService {

  @Resource
  private GlobalConfigRpService globalConfigRpService;

  @Override
  public SubChannelInfoDTO getDefaultBrandSubChannelInfo() {
    GlobalConfig config = globalConfigRpService.getById(
            GlobalConfigEnums.BRAND_MERCHANT_SUB_CHANNELS.getCode())
        .orElseThrow(() -> new BizException(FinanceErrorEnums.NOT_EXIST));
    return JSON.parseObject(config.getConfigValue(), SubChannelInfoDTO.class);
  }

  @Override
  public RefundConfigDTO getRefundConfig() {
    GlobalConfig config = globalConfigRpService.getById(GlobalConfigEnums.CASHIER_REFUND_CONFIG.getCode())
        .orElseThrow(() -> new BizException(FinanceErrorEnums.NOT_EXIST));
    return JSON.parseObject(config.getConfigValue(), RefundConfigDTO.class);
  }

}
