package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.merchant.request.BindBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.ListBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.UnbindBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/3/7 09:46
 */
@Component
public class BrandMerchantApiFallback implements FallbackFactory<BrandMerchantApi> {

  @Override
  public BrandMerchantApi create(Throwable throwable) {
    return new BrandMerchantApi() {
      @Override
      public JsonResult<Void> bind(BindBrandMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Void> unbind(UnbindBrandMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<BrandMerchantVO>> list(ListBrandMerchantRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
