package com.jiejing.fitness.finance.service.cashier;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierStatisticVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioCashierParams;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioSettleParams;
import com.jiejing.paycenter.common.enums.common.PayChannelEnums;
import java.util.List;
import java.util.Map;

/**
 * @author chengyubing
 * @since 2024/2/29 11:05
 */
public interface StudioCashierService {

  /**
   * 获取收银所需的所有appId
   *
   * @return 收银所需的所有appId
   */
  Map<PayChannelEnums, String> getAppId();

  /**
   * 绑定收银流水
   *
   * @param ids        流水ID集合
   * @param subOrderNo 业务子订单号
   */
  void bind(List<Long> ids, String orderNo, String businessNo, String subOrderNo);

  /**
   * 解绑收银流水
   *
   * @param ids 流水ID集合
   */
  void unbind(List<Long> ids);

  /**
   * 查询详情
   *
   * @param id ID
   * @return 结果
   */
  StudioCashierRecordVO getById(Long id);

  /**
   * 根据订单号查询列表
   *
   * @param orderNo 订单号
   * @return 结果
   */
  List<StudioCashierRecordVO> listByOrderNo(String orderNo);

  /**
   * 根据业务子订单号查询列表
   *
   * @param subOrderNos 业务子订单号
   * @return 结果
   */
  List<StudioCashierRecordVO> listBySubOrderNo(List<String> subOrderNos);

  /**
   * 分页查询收银流水
   *
   * @param params 参数
   * @return 结果
   */
  PageVO<StudioCashierRecordVO> page(PageStudioCashierParams params);

  /**
   * 分页查询结算记录
   *
   * @param params 参数
   * @return 结果
   */
  PageVO<StudioSettleVO> page(PageStudioSettleParams params);

  /**
   * 统计
   *
   * @param params 参数
   * @return 结果
   */
  StudioCashierStatisticVO statistic(PageStudioCashierParams params);

  /**
   * 查询流水集合
   *
   * @param ids 流水ID
   * @return 流水
   */
  List<StudioCashierRecordVO> listByIds(List<Long> ids);

  /**
   * 查询结算记录
   *
   * @param id ID
   * @return 结果
   */
  StudioSettleVO getSettle(Long id);

  /**
   * 根据关联流水号查询流水
   *
   * @param relatedTransNo 关联流水号
   * @return 结果
   */
  List<StudioCashierRecordVO> listByRelatedTransNo(String relatedTransNo);

}
