package com.jiejing.fitness.finance.api.config.request;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.fitness.enums.finance.FinanceConfigKeyEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/6/4 11:23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "获取finance的配置信息")
public class GetConfigRequest {

  @EnumMapping(enumClass = FinanceConfigKeyEnum.class)
  @ApiModelProperty(value = "配置key", required = true)
  @NotBlank(message = "key不能为空")
  private String key;

}
