package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.AuthBrandMerchantSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindBrandMerchantXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetAuthBrandMerchantSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantPayRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantRefundRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.paycenter.api.pay.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@Component
public class BrandMerchantApiFallback implements FallbackFactory<BrandMerchantApi> {

  @Override
  public BrandMerchantApi create(Throwable throwable) {
    return new BrandMerchantApi() {
      @Override
      public JsonResult<Void> apply(ApplyBrandMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantVO> get(GetBrandMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantApplyVO> getApply(GetBrandMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<BrandMerchantApplyVO>> pageApply(PageBrandMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantBindXcxAppIdVO> bindXcxAppId(BindBrandMerchantXcxAppIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantAuthSubChannelVO> authSubChannel(
          AuthBrandMerchantSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<BrandMerchantAuthSubChannelVO>> listAuthSubChannel(
          GetAuthBrandMerchantSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PayVO> pay(BrandMerchantPayRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<RefundVO> refund(BrandMerchantRefundRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
